/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.design.property.steps;

import filenet.vw.api.VWCompoundStepDefinition;
import filenet.vw.api.VWMapNode;
import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.design.canvas.process.VWPropertyMenuItem;
import filenet.vw.toolkit.design.property.VWAuthPropertyData;
import filenet.vw.toolkit.design.property.resources.VWResource;
import filenet.vw.toolkit.design.property.steps.IVWPropertyTab;
import filenet.vw.toolkit.design.property.steps.VWFunctionsSelectionPanel;
import filenet.vw.toolkit.utils.event.IVWPropertyChangeSource;
import filenet.vw.toolkit.utils.uicontrols.border.VWToolbarBorder;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Vector;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

class VWSystemStepGeneralTab
extends JPanel
implements IVWPropertyTab,
DocumentListener,
IVWPropertyChangeSource {
    private VWCompoundStepDefinition m_stepDefinition = null;
    private VWAuthPropertyData m_authPropertyData = null;
    private Vector m_changedItems = null;
    private JTextField m_nameTextField = null;
    private VWFunctionsSelectionPanel m_functionsPanel = null;

    public void init(VWAuthPropertyData authPropertyData, VWMapNode vwMapNode) {
        try {
            this.m_authPropertyData = authPropertyData;
            this.setLayout(new GridBagLayout());
            GridBagConstraints gbCons = new GridBagConstraints();
            gbCons.gridx = 0;
            gbCons.gridy = 0;
            gbCons.fill = 2;
            gbCons.weightx = 1.0;
            gbCons.weighty = 0.0;
            gbCons.anchor = 23;
            gbCons.gridheight = 1;
            gbCons.gridwidth = 1;
            gbCons.insets = new Insets(5, 5, 5, 10);
            this.add((Component)this.getNamePanel(), gbCons);
            ++gbCons.gridy;
            gbCons.fill = 1;
            gbCons.weighty = 1.0;
            gbCons.insets = new Insets(3, 5, 3, 10);
            this.m_functionsPanel = new VWFunctionsSelectionPanel();
            this.m_functionsPanel.init(this.m_authPropertyData, this.m_stepDefinition);
            this.add((Component)this.m_functionsPanel, gbCons);
            this.setSelectedStep(vwMapNode);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSelectedStep(VWMapNode vwMapNode) {
        if (vwMapNode == null || vwMapNode == this.m_stepDefinition) {
            return;
        }
        this.m_stepDefinition = (VWCompoundStepDefinition)vwMapNode;
        try {
            this.m_nameTextField.getDocument().removeDocumentListener(this);
            this.m_nameTextField.setText("");
            if (this.m_stepDefinition != null) {
                this.m_nameTextField.setText(this.getDisplayName());
                this.m_functionsPanel.setSelectedStep(this.m_authPropertyData, this.m_stepDefinition);
            } else {
                this.m_functionsPanel.reinitialize();
            }
            this.setEnabled(this.m_authPropertyData.isCurrentMapEditable());
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        finally {
            this.m_nameTextField.getDocument().addDocumentListener(this);
        }
    }

    public void releaseReferences() {
        if (this.m_nameTextField != null) {
            this.m_nameTextField.getDocument().removeDocumentListener(this);
            this.m_nameTextField = null;
        }
        if (this.m_functionsPanel != null) {
            this.m_functionsPanel.releaseReferences();
            this.m_functionsPanel = null;
        }
        if (this.m_changedItems != null) {
            this.m_changedItems.removeAllElements();
            this.m_changedItems = null;
        }
        this.m_authPropertyData = null;
        this.m_stepDefinition = null;
        this.removeAll();
    }

    public void changedUpdate(DocumentEvent event) {
    }

    public void insertUpdate(DocumentEvent event) {
        this.handleDocumentEvent(event);
    }

    public void removeUpdate(DocumentEvent event) {
        this.handleDocumentEvent(event);
    }

    public void notifyPropertyChange() {
        this.m_authPropertyData.getPropertyChangeEventNotifier().notifyPropertyChange(this, 501);
    }

    public Vector getItemsChanged() {
        return this.m_changedItems;
    }

    private JPanel getNamePanel() {
        try {
            VWToolbarBorder stepNameBorder = new VWToolbarBorder(VWResource.s_stepNameStr);
            JPanel childPanel = stepNameBorder.getClientPanel();
            childPanel.setLayout(new BorderLayout());
            this.m_nameTextField = new JTextField("", 15);
            this.m_nameTextField.getDocument().addDocumentListener(this);
            childPanel.add((Component)this.m_nameTextField, "First");
            return stepNameBorder;
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            return null;
        }
    }

    private String getDisplayName() {
        if (this.m_stepDefinition != null) {
            return VWPropertyMenuItem.getDisplayName(this.m_stepDefinition);
        }
        return null;
    }

    private void handleDocumentEvent(DocumentEvent event) {
        if (this.m_stepDefinition == null) {
            return;
        }
        if (event.getDocument() == this.m_nameTextField.getDocument()) {
            this.updateName();
        }
    }

    private void updateName() {
        try {
            if (this.m_stepDefinition != null && this.m_nameTextField != null) {
                String name = this.m_nameTextField.getText();
                String blankName = VWPropertyMenuItem.getBlankName(this.m_stepDefinition);
                if ((name.length() == 0 || name.equals(blankName)) && this.m_stepDefinition.getName() == null) {
                    return;
                }
                this.m_stepDefinition.setName(name);
                this.m_authPropertyData.setDirty();
                this.m_changedItems = new Vector();
                this.m_changedItems.addElement(this.m_stepDefinition);
                this.notifyPropertyChange();
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }
}

